%This scriot return the coefficients for the caliibration curve:
%fitResults#
%These are used when reading the data for the sediment concentration
clear all;
close all;

% Path of measurements

fileName = {'Guyana_MF901220200220164021'};
Path1    = 'F:\OBS_Calibration\';
Folder   = {'VEC12422_OBS9012_Mudflat\'};

file_name = 'Guyana_MF901220200220164021';
Path = strcat(Path1,'VEC12422_OBS9012_Mudflat\');



load Guyana_MF901220200220164021.mat
load Sed_Input.mat
load Filtration_9012_conc.mat

% Cleaning Data, Calibration
clean_rawdata_counts=ADVData.Data.AnalogueInput2(2700:65520);
clean_data_Volt= clean_rawdata_counts*5/65535;
clean_data_NTU= 2.5920.*(clean_data_Volt).^2+91.163.*clean_data_Volt-0.53091;

%clean_data_NTU(:,1)=ADVData.Data.NTU2(2700:65520);
% Create matrix of dates
date_data=ADVData.Data.FullDate(2700:65520);
date_data_double=datenum(date_data);
clean_data_NTU(:,2)=date_data_double;


%Time for Inputing Sediment, Sed_input must be added during Calibration (9012)
Sed= Sed_input;
Sed = datetime(Sed,'InputFormat','dd-MMM-yyyy HH:mm:ss');
Sed= datenum(Sed);

%Array to plot the vertical lines on the plot
Sed_hor=Sed.';

figure;
axes1 = axes;
scatter(clean_data_NTU(:,2),clean_data_NTU(:,1));
hold on;
[f1,f2, f3]= polyfit(clean_data_NTU(:,2),clean_data_NTU(:,1), 4);
fitResults1= polyfit(clean_data_NTU(:,2),clean_data_NTU(:,1), 4);
ft= polyval(f1,clean_data_NTU(:,2),[],f3);

% Save type of fit for "Show equations"
fittypesArray1(1) = 3;

% Save coefficients for "Show Equation"
coeffs1{1} = fitResults1;

plot(clean_data_NTU(:,2),ft);
hold on;
plot([Sed_hor; Sed_hor], repmat(ylim',1,size(Sed_hor,2)), '-k','LineStyle',':','Color',[0 0 0])
hold on;

n=1;
for i=1:1:23
    disp(n)
    row=find(clean_data_NTU(:,2)==Sed(i));
    disp(row)
    if isempty(row) 
        row=1;
    else
        row=row;
    end
    disp(row)
    mean_NTU(i,1)=(sum(clean_data_NTU(n:row,1)))/((row-n)+1);
    mean_NTU(i,2)=(sum(clean_data_NTU(n:row,2)))/((row-n)+1);
    
    mode_NTU(i,1)=mode(clean_data_NTU(n:row,1));
    mode_NTU(i,2)=(sum(clean_data_NTU(n:row,2)))/((row-n)+1);
    
    max_NTU(i,1)=max(clean_data_NTU(n:row,1));
    max_NTU(i,2)=(sum(clean_data_NTU(n:row,2)))/((row-n)+1);
    n=row;
end
disp(mean_NTU)

plot(mean_NTU(:,2),mean_NTU(:,1));

datetick('x', 'yyyy-mm-dd HH:MM:SS')

% Uncomment the following line to preserve the X-limits of the axes
xlim([737841.697222222 737841.895138889]);
% Uncomment the following line to preserve the Y-limits of the axes
ylim([0.764522859909809 395.39841517506]);

% Create ylabel
ylabel('NTU Values','FontWeight','bold');

% Create xlabel
xlabel('Time (yyyy-mm-dd HH:MM:SS)','FontWeight','bold');

% Create title
title('Trend in the NTU values during the Calibration of OBS 9012');

set(axes1,'FontSize',20,'XGrid','on','XTick',...
    [737841.625 737841.6875 737841.7 737841.75 737841.8125 737841.875],...
    'XTickLabel',...
    {'2020-02-20 15:00:00','2020-02-20 16:30:00','2020-02-20 16:47:28','2020-02-20 18:00:00','2020-02-20 19:30:00','2020-02-20 21:00:00'},...
    'YGrid','on');

% Create textarrow
annotation('textarrow',[0.272857142857144 0.321428571428572],...
    [0.856142857142857 0.747465437788018],'String',{'Sed Input Locations'},...
    'FontSize',18,...
    'FontAngle','italic');

% Create textarrow
annotation('textarrow',[0.649285714285719 0.697857142857147],...
    [0.81789400921659 0.709216589861751],...
    'String',{'Shape Preserving Polynomial'},...
    'FontSize',18,...
    'FontAngle','italic');

showEquations(fittypesArray1,coeffs1,5,axes1);

hold off;

%Use the Basic Fitting Tool in Matlab
% Get the coefficient for the curve to fit

% Calculating concentration using empirical relationships

Concentration_calibration=mean_NTU(:,1);

% Insert the concentrations from the flitration here
Concentration_calibration (:,2)=Filtration_9012;

% %Testing Coefficients
% jj=1;
% NTU_clean=clean_data_NTU(:,1);
% test_coeff_concentration(:,1) = polyval(fit3.coeff(1,:),(max_NTU(:,1)).');
% %test_coeff_concentration(:,2) = date_data_double;
% test_coeff_concentration(:,2) = Sed(1:23);
%% Plots for the Concentration:mean, mode and max values for the NTU

figure(2);
ax2=axes;
scatter(mean_NTU(:,1),Concentration_calibration(:,2));

% Create ylabel
ylabel('Concentration (g/l)','FontWeight','bold');

% Create xlabel
xlabel('Mean of the NTU Values','FontWeight','bold');

% Create title
title({'Calibration Curve: Concentration (g/l) VS Mean NTU','Muflat, Frame # 5 - OBS 9012'});

set(ax2,'FontSize',20,'XGrid','on','YGrid','on');

figure(3);
ax3=axes;
scatter(mode_NTU(:,1),Concentration_calibration(:,2));
% Create ylabel
ylabel('Concentration (g/l)','FontWeight','bold');

% Create xlabel
xlabel('Mode of the NTU Values','FontWeight','bold');

% Create title
title({'Calibration Curve: Concentration (g/l) VS Mode NTU','Muflat, Frame # 5 - OBS 9012'});

set(ax3,'FontSize',20,'XGrid','on','YGrid','on');


figure(4);
ax4=axes;
hold on;
plot(mean_NTU(:,1),Concentration_calibration(:,2),'DisplayName','Mudflat, Guyana OBS 9012','LineWidth',3,...
    'Color',[0.600000023841858 0.200000002980232 0]);
hold on;
[r1,c1]=find(mean_NTU(:,1)>1 & mean_NTU(:,1)<330);
plot(mean_NTU(r1,1),Concentration_calibration(r1,2),'DisplayName','Mudflat, Guyana OBS 9012- Linear','LineWidth',3,...
    'Color',[1 1 0]);
% Create ylabel
ylabel('Concentration (g/l)','FontWeight','bold');

% Create xlabel
xlabel('Max of the NTU Values','FontWeight','bold');

% Create title
title({'Calibration Curve: Concentration (g/l) VS Max NTU','Muflat, Frame # 5 - OBS 9012'});

% Uncomment the following line to preserve the X-limits of the axes
% xlim(axes1,[-10 410]);
box on;
% Set the remaining axes properties
set(ax4,'FontSize',20,'XColor',[0 0 0],'XGrid','on','YColor',[0 0 0],...
    'YGrid','on','ZColor',[0 0 0]);
% Create legend
legend1 = legend(ax4,'show');
set(legend1,...
    'Position',[0.12682882761576 0.701000179342653 0.336063225529659 0.161084047508007],...
    'FontSize',20);

% Find x values for plotting the fit based on xlim
axesLimits1 = xlim(ax4);
xplot1 = linspace(axesLimits1(1), axesLimits1(2));

% Preallocate for "Show equations" coefficients
coeffs2 = cell(2,1);

% Find coefficients for polynomial (order = 2)
fitResults2 = polyfit(mean_NTU(r1,1),Concentration_calibration(r1,2),2);
% Evaluate polynomial
yplot1 = polyval(fitResults2,xplot1);

% Save type of fit for "Show equations"
fittypesArray2(1) = 3;

% Save coefficients for "Show Equation"
coeffs2{1} = fitResults2;

% Plot the fit
fitLine1 = plot(xplot1,yplot1,'DisplayName','   quadratic',...
    'Tag','quadratic',...
    'Parent',ax4,...
    'Color',[0.494 0.184 0.556]);

showEquations(fittypesArray2,coeffs2,5,ax4);

%% Saving results
file_output='coefficients_fit';
fullname=strcat(Path,file_output,'.mat');
save(fullname,'fitResults2')

%% Instrument (ADV) was not submerged during the calibration process
% %Concentration Plot Using the SNR/ Correlation
% 
% %This script return the coefficients for the caliibration curve
% %These are used when reading the data for the sediment concentration
% 
% close all;
% % Cleaning Data, Calibration
% mean_SNR_clean=(ADVData.Data.SNRBeam1(2700:65520)+ADVData.Data.SNRBeam2(2700:65520)+ADVData.Data.SNRBeam3(2700:65520))./3;
% mean_COR_clean=(ADVData.Data.CorrelationBeam1(2700:65520)+ADVData.Data.CorrelationBeam2(2700:65520)+ADVData.Data.CorrelationBeam3(2700:65520))./3;
% clean_data_SNR(:,1)=mean_COR_clean;
% 
% %clean_data_NTU(:,1)=ADVData.Data.NTU2(2700:65520);
% % Create matrix of dates
% %date_data=ADVData.Data.FullDate(2700:65520);
% %date_data_double=datenum(date_data);
% clean_data_SNR(:,2)=date_data_double;
% 
% 
% %Time for Inputing Sediment, Sed_input must be added during Calibration (9012)
% % Sed= Sed_input;
% % Sed = datetime(Sed,'InputFormat','dd-MMM-yyyy HH:mm:ss');
% % Sed= datenum(Sed);
% % 
% % %Array to plot the vertical lines on the plot
% % Sed_hor=Sed.';
% 
% figure(5);
% axes2 = axes;
% scatter(clean_data_SNR(:,2),clean_data_SNR(:,1));
% hold on;
% [f4,f5, f6]= polyfit(clean_data_SNR(:,2),clean_data_SNR(:,1), 4);
% fitResults3= polyfit(clean_data_SNR(:,2),clean_data_SNR(:,1), 4);
% ft2= polyval(f4,clean_data_SNR(:,2),[],f6);
% 
% % Save type of fit for "Show equations"
% fittypesArray3(1) = 3;
% 
% % Save coefficients for "Show Equation"
% coeffs3{1} = fitResults3;
% 
% plot(clean_data_SNR(:,2),ft2);
% hold on;
% plot([Sed_hor; Sed_hor], repmat(ylim',1,size(Sed_hor,2)), '-k','LineStyle',':','Color',[0 0 0])
% hold on;
% 
% n=1;
% for i=1:1:23
%     disp(n)
%     row=find(clean_data_SNR(:,2)==Sed(i));
%     disp(row)
%     if isempty(row) 
%         row=1;
%     else
%         row=row;
%     end
%     disp(row)
%     mean_SNR(i,1)=(sum(clean_data_SNR(n:row,1)))/((row-n)+1);
%     mean_SNR(i,2)=(sum(clean_data_SNR(n:row,2)))/((row-n)+1);
%     
%     mode_SNR(i,1)=mode(clean_data_SNR(n:row,1));
%     mode_SNR(i,2)=(sum(clean_data_SNR(n:row,2)))/((row-n)+1);
%     
%     max_SNR(i,1)=max(clean_data_SNR(n:row,1));
%     max_SNR(i,2)=(sum(clean_data_SNR(n:row,2)))/((row-n)+1);
%     n=row;
% end
% disp(mean_SNR)
% 
% plot(mean_SNR(:,2),mean_SNR(:,1));
% 
% datetick('x', 'yyyy-mm-dd HH:MM:SS')
% 
% % Uncomment the following line to preserve the X-limits of the axes
% xlim([737841.697222222 737841.895138889]);
% % Uncomment the following line to preserve the Y-limits of the axes
% ylim([0.764522859909809 395.39841517506]);
% 
% % Create ylabel
% ylabel('SNR Values','FontWeight','bold');
% 
% % Create xlabel
% xlabel('Time (yyyy-mm-dd HH:MM:SS)','FontWeight','bold');
% 
% % Create title
% title('Trend in the SNR values during the Calibration of OBS 9012');
% 
% set(axes2,'FontSize',20,'XGrid','on','XTick',...
%     [737841.625 737841.6875 737841.7 737841.75 737841.8125 737841.875],...
%     'XTickLabel',...
%     {'2020-02-20 15:00:00','2020-02-20 16:30:00','2020-02-20 16:47:28','2020-02-20 18:00:00','2020-02-20 19:30:00','2020-02-20 21:00:00'},...
%     'YGrid','on');
% 
% % Create textarrow
% annotation('textarrow',[0.272857142857144 0.321428571428572],...
%     [0.856142857142857 0.747465437788018],'String',{'Sed Input Locations'},...
%     'FontSize',18,...
%     'FontAngle','italic');
% 
% % Create textarrow
% annotation('textarrow',[0.649285714285719 0.697857142857147],...
%     [0.81789400921659 0.709216589861751],...
%     'String',{'Shape Preserving Polynomial'},...
%     'FontSize',18,...
%     'FontAngle','italic');
% 
% showEquations(fittypesArray3,coeffs3,5,axes2);
% 
% hold off;
% 
% %Use the Basic Fitting Tool in Matlab
% % Get the coefficient for the curve to fit
% 
% % Calculating concentration using empirical relationships
% 
% Concentration_calibration_SNR=mean_SNR(:,1);
% 
% % Insert the concentrations from the flitration here
% Concentration_calibration_SNR(:,2)=Filtration_9012;
% 
% %Testing Coefficients
% jj=1;
% SNR_clean=clean_data_SNR(:,1);
% test_coeff_concentration_SNR(:,1) = polyval(fit3.coeff(1,:),(max_SNR(:,1)).');
% %test_coeff_concentration(:,2) = date_data_double;
% test_coeff_concentration_SNR(:,2) = Sed(1:23);
% 
% figure (6);
% % scatter(mean_SNR(:,1),Concentration_calibration_SNR(:,2));
% ax5=axes;
% hold on;
% plot(mean_SNR(:,1),Concentration_calibration_SNR(:,2),'DisplayName','Mudflat, Guyana OBS 9012','LineWidth',3,...
%     'Color',[0.600000023841858 0.200000002980232 0]);
% % hold on;
% % [r1,c1]=find(mean_SNR(:,1)>1 & mean_NTU(:,1)<330);
% % plot(mean_NTU(r1,1),Concentration_calibration(r1,2),'DisplayName','Mudflat, Guyana OBS 9012- Linear','LineWidth',3,...
% %     'Color',[1 1 0]);
% % Create ylabel
% ylabel('Concentration (g/l)','FontWeight','bold');
% 
% % Create xlabel
% xlabel('Mean of the SNR Values','FontWeight','bold');
% 
% % Create title
% title({'Calibration Curve: Concentration (g/l) VS Max SNR','Muflat, Frame # 5 - OBS 9012'});
% 
% % Uncomment the following line to preserve the X-limits of the axes
% % xlim(axes1,[-10 410]);
% box on;
% % Set the remaining axes properties
% set(ax5,'FontSize',20,'XColor',[0 0 0],'XGrid','on','YColor',[0 0 0],...
%     'YGrid','on','ZColor',[0 0 0]);
% % Create legend
% legend1 = legend(ax5,'show');
% set(legend1,...
%     'Position',[0.12682882761576 0.701000179342653 0.336063225529659 0.161084047508007],...
%     'FontSize',20);
% 
% % Find x values for plotting the fit based on xlim
% axesLimits2 = xlim(ax5);
% xplot2 = linspace(axesLimits2(1), axesLimits2(2));
% 
% % Preallocate for "Show equations" coefficients
% coeffs4 = cell(2,1);
% 
% % Find coefficients for polynomial (order = 2)
% fitResults4 = polyfit(mean_NTU(r1,1),Concentration_calibration(r1,2),2);
% % Evaluate polynomial
% yplot2 = polyval(fitResults4,xplot2);
% 
% % Save type of fit for "Show equations"
% fittypesArray4(1) = 3;
% 
% % Save coefficients for "Show Equation"
% coeffs4{1} = fitResults4;
% 
% % Plot the fit
% fitLine1 = plot(xplot2,yplot2,'DisplayName','   quadratic',...
%     'Tag','quadratic',...
%     'Parent',ax5,...
%     'Color',[0.494 0.184 0.556]);
% 
% showEquations(fittypesArray4,coeffs4,5,ax5);
% 
% 
% figure (8);
% scatter(mode_SNR(:,1),Concentration_calibration_SNR(:,2));
% 
% figure9 = figure;
% 
% % Create axes
% % axes2 = axes('Parent',figure9);
% % hold(axes2,'on');
% plot(max_SNR(:,1),Concentration_calibration_SNR(:,2),'DisplayName','Mudflat, Guyana OBS 9012','LineWidth',3,...
%     'Color',[0.600000023841858 0.200000002980232 0]);
% % Create ylabel
% ylabel('Concentration (g/l)','FontWeight','bold');
% 
% % Create xlabel
% xlabel('SNR [dB]','FontWeight','bold');
% 
% % Create title
% title({'Calibration Curve: Concentration (g/l) VS SNR','Muflat, Frame # 5 - OBS 9012'});
% 
% % % Uncomment the following line to preserve the X-limits of the axes
% % % xlim(axes1,[-10 410]);
% % box(axes2,'on');
% % % Set the remaining axes properties
% % set(axes2,'FontSize',16,'XColor',[0 0 0],'XGrid','on','YColor',[0 0 0],...
% %     'YGrid','on','ZColor',[0 0 0]);
% % % Create legend
% % legend1 = legend(axes2,'show');
% % set(legend1,...
% %     'Position',[0.665083652815722 0.125672042065869 0.185595241796402 0.0660138263350807],...
% %     'FontSize',16);
% 
